#include <iostream>
#include <cstdio>
#include <vector>
#include <string>
#include <sstream>
#include <cmath>

using namespace std;

const int maxn = 1 << 17;

string s;
int n;

struct pt {
	double x, y;

	pt() {}
	pt(double x, double y) : x(x), y(y) {}

	pt operator+ (const pt &p) {
		return pt(x + p.x, y + p.y);
	}

	pt operator- (const pt &p) {
		return pt(x - p.x, y - p.y);
	}

	double operator* (const pt &p) {
		return x * p.x + y * p.y;
	}

	pt operator* (const double d) {
		return pt(x * d, y * d);
	}

	double d() {
		return sqrt(x * x + y * y);
	}
};

struct item {
	bool isPt;
	double x1, y1, x2, y2;
};

item apply(item a, item b) {
	if (!a.isPt && b.isPt) swap(a, b);
	if (a.isPt && b.isPt) {
		item res;
		res.isPt = 0;
		res.x1 = a.x1;
		res.y1 = a.y1;
		res.x2 = b.x1;
		res.y2 = b.y1;
		return res;
	}
	if (!a.isPt && !b.isPt) {
		double A1 = a.y1 - a.y2;
		double B1 = a.x2 - a.x1;
		double C1 = -(A1 * a.x1 + B1 * a.y1);
		
		double A2 = b.y1 - b.y2;
		double B2 = b.x2 - b.x1;
		double C2 = -(A2 * b.x1 + B2 * b.y1);

		double det = A1 * B2 - A2 * B1;
		double detx= C1 * B2 - C2 * B1;
		double dety= A1 * C2 - A2 * C1;
		
		item res;
		res.isPt = 1;
		res.x1 = -detx/det;
		res.y1 = -dety/det;
		return res;
	} else {
		pt A(a.x1, a.y1);
		pt B(b.x1, b.y1);
		pt C(b.x2, b.y2);
		double len = ((C-B) * (A-B)) / (C-B).d();
		pt D = B + ((C - B) * (len / (C-B).d()));
		pt E = A + ((D-A) * 2);

		item res;
		res.isPt = 1;
		res.x1 = E.x;
		res.y1 = E.y;
		return res;
	}
}

item solve(int l, int r) {
	int cnt = 0;
	int pos = -1;
	int balance = 0;
	for (int i = l; i <= r; i++) {
		balance += s[i] == '(';
		balance -= s[i] == ')';
		cnt += s[i] == '@';
		if (s[i] == '@' && balance == 0) {
			pos = i;
		}
	}
	if (pos != -1) {
		item o1 = solve(l, pos - 1);
		item o2 = solve(pos + 1, r);
		return apply(o1, o2);
	} else {
		if (s[l + 1] == '(') {
			return solve(l + 1, r - 1);
		} else {
			stringstream ss;
			for (int i = l; i <= r; i++) ss << s[i];
			char c;
			double x, y;
			ss >> c >> x >> c >> y;
			item res;
			res.isPt = true;
			res.x1 = x;
			res.y1 = y;
			return res;
		}
	}
}

int main() {
	freopen("input.txt", "r", stdin);

	while (1) {
		cin >> s;
		if (s == "#") break;
		n = s.length();
		item o = solve(0, n - 1);
		printf("%.10lf %.10lf\n", o.x1, o.y1);
	}

	return 0;
}